package gov.va.med.domain.service.messaging;

import java.io.Serializable;

import gov.va.med.domain.model.IPayload;

/**
 * Message
 *
 * @author Odysseas Pentakalos
 * @version $Id: Message.java,v 1.3 2005/07/13 12:59:54 slava.uchitel Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class Message implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 3258689927104770610L;
    private IPayload _payload;
    private MessageType _messageType;

    // FUTURE resolve the duplicity of Function and MessageType
    // MessageTypes may be reused by Functions and Function
    // is the more important concept.  
    public Message(MessageType messageType, IPayload payload) {
        setMessageType(messageType);
        setPayload(payload);
    }

 
    public void setMessageType(MessageType messageType) { _messageType = messageType; }
    public MessageType getMessageType() {return _messageType;}

    public IPayload getPayload() { return _payload; }
    public void setPayload(IPayload payload) { _payload = payload; }


}
